string GetDescription()
{
	return "Drums - generates a randomized drum pattern in a dance style using Hi-Hats";
}

struct Pattern
{
	double Length;
	int[] Pitches;	
	int velfrom;
	int velto;
	double[] pattern;
};

Pattern NewPattern(double l, int[] pit, double[] pat, int v1, int v2)
{
	Pattern p;
	p.Length = l;
	p.Pitches = pit;
	p.pattern = pat;
	p.velfrom = v1;
	p.velto = v2;
	return p;	
}

void RealizePattern(RenderPart @p, Pattern pat)
{
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=pat.Length)
		{
			for (uint n = 0; n < pat.pattern.length(); n++)
			{
				if (pat.pattern[n] + m < p.GetUniquePart().GetMetrum())
				{
					for (uint q = 0; q < pat.Pitches.length(); q++)
						p.AddPercNote( CreateTime(i, m+pat.pattern[n]), CreateTime(i, m+pat.pattern[n]+0.1), pat.Pitches[q], RndInt(pat.velfrom,pat.velto));
				}	
			}
		}
	}	
}

void Render(RenderPart @p)
{
	Pattern[] patterns(50);
	
	int w = 0;
	
	bool b42 = false;
	
	if (RndInt(0,1) == 0)
	{
		int[] pit2 = {42}; double[] pat2 = {0, 0.25 , 0.5};
		patterns[w++] = NewPattern(1, pit2, pat2, 115, 120);
		b42 = true;
	}
	else
	{
		int[] pit2 = {44}; double[] pat2 = {0};
		patterns[w++] = NewPattern(1, pit2, pat2, 115, 120);
		
		int[] pit3 = {82}; double[] pat3 = {0.5};
		patterns[w++] = NewPattern(1, pit3, pat3, 115, 120);
	}
	
	int[] pit4 = {44}; double[] pat4 = {0.5+0.25*RndInt(0,1)};
	patterns[w++] = NewPattern(1, pit4, pat4, 115, 120);

	int[] pit5 = {46}; double[] pat5 = {0.51+0.25*RndInt(0,1)};
	patterns[w++] = NewPattern(1, pit5, pat5, 115, 120);
	
	
	if (RndInt(0,1) == 0 && !b42)
	{
		int[] pit5 = {42}; 
		if (b42) pit5[0] = 37;
		double[] pat5 = {0, 0.5, 0.75 };
		patterns[w++] = NewPattern(1.0, pit5, pat5, 80, 90);
	}
	
	if (p.GetTempo() < 90)
	{
		for (int i = 0; i < w; i++)
		{
			patterns[i].Length /= 2.0;
			for (int y = 0; y < patterns[i].pattern.length(); y++)
				patterns[i].pattern[y] /= 2.0;
		}
	}
	
	if (p.GetTempo() > 199)
	{
		for (int i = 0; i < w; i++)
		{
			patterns[i].Length *= 2.0;
			for (int y = 0; y < patterns[i].pattern.length(); y++)
				patterns[i].pattern[y] *= 2.0;
		}
	}
	
	for (int i = 0; i < w; i++)
		RealizePattern(p, patterns[i]);	
	
}